
/**
 * Title:        FakeRMI implementation<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Joe Schwartz<p>
 * Company:      Alkindi, LLC<p>
 * @author Joe Schwartz
 * @version 1.0
 */
package Alkindi.RMITest;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;

import Alkindi.BusinessServices.IRatingManager;

import Alkindi.BusinessDataTypes.RatingList;
import Alkindi.BusinessDataTypes.Rating;
import Alkindi.BusinessDataTypes.SystemUser;
import Alkindi.BusinessDataTypes.ProductList;

public class RatingManager extends UnicastRemoteObject implements IRatingManager
{

	public RatingManager () throws RemoteException
	{
	}

	/**
	Retrieves a list of products for a New User to rate.
	@roseuid 39C13F1A0271
	*/
	public ProductList getInitialProductsToRate() throws RemoteException
	{
		return new BogusProductList();
	}

	/**
	Generates a list of products for the given SystemUser to rate.
	@roseuid 3999BF550242
	*/
	public ProductList getProductsToRate(final SystemUser user, final int numDesired) throws RemoteException
	{
		return new BogusProductList();
	}

	/**
	Stores the given Ratings.
	@roseuid 399DAE01037A
	*/
	public boolean rateProducts(final RatingList ratings) throws RemoteException
	{
		return true;
	}

	/**
	Calculates or retrieves the given user's Alkindex.
	@roseuid 39C919A60128
	*/
	public int getAlkindex(final SystemUser user) throws RemoteException
	{
		return 99;
	}


}